/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.table.VWCheckBoxTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class VWCheckBoxTableCellEditor
extends JCheckBox
implements TableCellEditor,
ActionListener,
FocusListener,
KeyListener {
    private static final int CLICK_COUNT_TO_START = 1;
    private static final int VALUE_NA = 0;
    private static final int VALUE_NO_CHANGE = 1;
    private static final int VALUE_UPDATED = 2;
    private Object m_currentValue = null;

    public VWCheckBoxTableCellEditor() {
        this.addActionListener(this);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.m_currentValue = value;
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        Border border = null;
        if (isSelected) {
            border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
        }
        if (border == null) {
            border = UIManager.getBorder("Table.focusCellHighlightBorder");
        }
        this.setBorder(new CompoundBorder(border, VWCheckBoxTableCellRenderer.BORDER_INSETS));
        if (!isSelected && table.isCellEditable(row, column)) {
            Color col = UIManager.getColor("Table.focusCellForeground");
            if (col != null) {
                this.setForeground(col);
            }
            if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                this.setBackground(col);
            }
        }
        if (value != null && value instanceof JCheckBox) {
            JCheckBox tableCheckBox = (JCheckBox)value;
            this.setText(tableCheckBox.getText());
            this.setSelected(tableCheckBox.isSelected());
        }
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
        return this;
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.listenerList.add(CellEditorListener.class, listener);
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public int getClickCountToStart() {
        return 1;
    }

    public Object getCellEditorValue() {
        return this.m_currentValue;
    }

    public boolean isCellEditable(EventObject anEvent) {
        boolean result = true;
        if (anEvent != null && anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getClickCount() < 1) {
            result = false;
        }
        return result;
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.listenerList.remove(CellEditorListener.class, listener);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        boolean bRetValue = true;
        if (this.isCellEditable(anEvent) && (anEvent == null || ((MouseEvent)anEvent).getClickCount() >= 1)) {
            bRetValue = this.startCellEditing(anEvent);
        }
        return bRetValue;
    }

    public void setClickCountToStart(int count) {
    }

    public boolean startCellEditing(EventObject evt) {
        return true;
    }

    public boolean stopCellEditing() {
        this.updateCurrentValue();
        this.fireEditingStopped();
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        int nResult = this.updateCurrentValue();
        if (nResult == 2) {
            this.fireEditingStopped();
        } else if (nResult != 0) {
            this.cancelCellEditing();
        }
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        int nResult = this.updateCurrentValue();
        if (nResult == 2) {
            this.fireEditingStopped();
        } else if (nResult != 0) {
            this.cancelCellEditing();
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        if (event.getKeyChar() == '\r') {
            int result = this.updateCurrentValue();
            if (result == 2) {
                this.fireEditingStopped();
            } else if (result != 0) {
                this.cancelCellEditing();
            }
        }
    }

    protected int updateCurrentValue() {
        int nResult = 1;
        try {
            if (this.m_currentValue != null && this.m_currentValue instanceof JCheckBox && this.isSelected() != ((JCheckBox)this.m_currentValue).isSelected()) {
                ((JCheckBox)this.m_currentValue).setSelected(this.isSelected());
                nResult = 2;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return nResult;
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
        }
    }
}

